/*
 * Created on 31 janv. 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.cocoon.actions;

import java.io.IOException;
import java.rmi.ServerException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;


import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.methods.DepthSupport;
import org.injac.utils.WebdavConnection;
import org.w3c.dom.Element;

import org.injac.utils.*;

/**
 * @author shoam
 * 
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class DisplayFileAction extends AbstractAction {

	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(DisplayFileAction.class);

	/**
	 * Connection with session management
	 * 
	 * @uml.property name="webdavConnection"
	 * @uml.associationEnd multiplicity="(0 1)"
	 */
	private WebdavConnection webdavConnection;

	/**
	 * The dav ressource uri
	 */
	private String webdavpath;
	/**
	 * space path 
	 */
	private String space;
	/**
	 * document path 
	 */
	private String doc;
	/**
	 * file name
	 */
	private String file;
	/**
	 * root node ex : /slide/file/injacRoot
	 */
	private String rootpath;
	/**
	 * Credentials
	 */
	private String login;
	private String password;
	
	private String injacType=null;
	private String rootdocname=null;
	private String rootfilename=null;
	/**
	 * Vector with requested MD name
	 */
	private Vector mdVector;
	/**
	 * Action testant les MD passs dans le paramtre reqparams selon la rgle suivante :
	 * - md1 : injac-type
	 * - md2 : root-doc-name
	 * - md3 : root-file-name
	 */
	public Map act (Redirector redirector, 
            SourceResolver resolver, 
            Map objectModel, 
            String source, 
            Parameters params) throws Exception{
		
		String reqparams;

		Map sitemapParams = new HashMap();
		mdVector = new Vector();
		webdavConnection = new WebdavConnection(objectModel);
		try {
			webdavpath= (String)params.getParameter("webdav-path");			
			rootpath = webdavpath.substring(webdavpath.indexOf("/slide"));
			space= (String)params.getParameter("space");
			doc= (String)params.getParameter("doc");
			file= (String)params.getParameter("file");
			
			
			if((space==null) || space.equals(""))
				space="";
			
			try {
				reqparams=(String)params.getParameter("reqparams");
				// parsing des MD demands
				logger.debug("reqparams: "+reqparams);
            	if(reqparams.equals(""))
            	{
            		// MD par dfaut
    				logger.debug("reqparams: vide");
                	mdVector.add("D:injac-type");
                    mdVector.add("D:root-doc-name");
                    mdVector.add("D:root-file-name");
            	}else
            	{
            		for(StringTokenizer ST = new StringTokenizer(reqparams, " ");ST.hasMoreTokens(); )
            		{
            			mdVector.add(ST.nextToken());
            		}
            	}
				
			}catch(ParameterException pe)
			{
				// MD par dfaut
				logger.debug("reqparams: null");
				mdVector.add("D:injac-type");
                mdVector.add("D:root-file-name");
                mdVector.add("D:root-doc-name");
			}
			// Rcupration des credentials
			try {
				login=(String)params.getParameter("login");
				password=(String)params.getParameter("password");
			}
			catch(Exception e)
			{
				login=null;
				password=null;
			}
			logger.debug("DisplayFileAction::Act params : \t-space : "+space+"\t-doc : "+doc+"\t-file : "+file);
			if(webdavpath != null)
			{
				logger.debug("connecting to webdav-path : "+webdavpath);
				connect(webdavpath);
               	logger.debug("DisplayFileAction::Act : connection ressource : "+webdavpath+ " okay");
			}
			else
			{
				String msg = "DisplayFileAction::act : pas de chemin pass en argument.\n parma manquant : webdav-path";
				logger.error(msg);
				throw new Exception(msg);
			}
			
		} catch (Exception e) {

			throw new Exception("DisplayFileAction::act : problme de paramtres.\n webdavpath :"+webdavpath+"\nlogin: "+login, e);
		}
		buildResponse(sitemapParams);
		logger.debug("DisplayFileAction::Act : connection ressource : "+webdavpath+ " ok");
		logger.debug("return value :"+sitemapParams); 
		if(sitemapParams.isEmpty())
			return null;
		return sitemapParams;
	}
	/** TODO utiliser tagname pour les tests autres que sur DAV: retourns en D:
	 * 
	 * @param prop
	 * @param sitemapParams
	 */
	void parseProperty(Property prop)
	{
		Element el=prop.getElement();
		String tagname =el.getNodeName();
		// cas o l'lment n'a pas de contenu
		String value="";
		if(el.hasChildNodes())
			value=el.getFirstChild().getNodeValue();
		
		String mapname=tagname.substring(tagname.indexOf(":")+1);
		// test de injac type
		if(mapname.equals(((String)mdVector.elementAt(0)).substring(((String)mdVector.elementAt(0)).indexOf(":")+1)))
			injacType=value;
		if(mapname.equals(((String)mdVector.elementAt(1)).substring(((String)mdVector.elementAt(1)).indexOf(":")+1)))
			rootdocname=value;
		if(mapname.equals(((String)mdVector.elementAt(2)).substring(((String)mdVector.elementAt(2)).indexOf(":")+1)))
			rootfilename=value;
		logger.debug("tagname : "+tagname+" mapname : "+mapname+" value : "+value);
			
	}
	
	public void buildResponse(Map sitemapParams)throws Exception
	{
		Enumeration resp_enum=null;
	    
        Enumeration md = getProperty(mdVector);
        logger.debug("DisplayFileAction::buildResponse : PropFind methode ok");
        logger.debug("enum 1 count:"+md.toString());
		try
		{
			int i=0;
			           
			while(md.hasMoreElements())
			{
				Object resp_element =md.nextElement();
				logger.debug("class resp_element : "+resp_element.getClass()+" resp_element.toString : "+resp_element.toString());
				if(resp_element.getClass().getName().equals("org.apache.webdav.lib.BaseProperty"))
				{
					org.apache.webdav.lib.BaseProperty prop = (org.apache.webdav.lib.BaseProperty)resp_element;
					logger.debug("property : "+prop.getName());
					logger.debug("--> : "+prop);
					parseProperty(prop);
					logger.debug("parseProperty ok");
				}
				i++;
            }
			logger.debug("DisplayFileAction::buildresponse: injacType : "+ injacType+"\nrootdocname :"+rootdocname+"\nrootfilename :"+rootfilename);
			// 1. doc is already set, return them with correct file 
			if((doc !=null) && (!doc.equals("")))
			{
				// 1.a file is already set
				if((file !=null) && (!file.equals("")))
				{
					sitemapParams.put("file", file);
					sitemapParams.put("filepath", space+doc);
				}
				else
				{
					fetchRootFileName(doc);
					sitemapParams.put("file", rootfilename);
					sitemapParams.put("filepath", space+doc);
				}
				// send back doc
				sitemapParams.put("adoc", doc);
			}
			// 2. doc is not set, but there is a md
			else if((rootdocname !=null) && (!rootdocname.equals("")))
			{
				// test if doc is published
				if(CheckDocPublished(rootdocname))
				{
					fetchRootFileName("/"+rootdocname);
					sitemapParams.put("file", rootfilename);
					sitemapParams.put("filepath", space+"/"+rootdocname);
					// add the doc path to sitemap
					sitemapParams.put("adoc", "/"+rootdocname);
				}
			}
			
			// no file to render as document
			if(sitemapParams.isEmpty())
			{
				sitemapParams.put("file", "void.xml");
				sitemapParams.put("filepath", "");
				sitemapParams.put("adoc", "");
			}
			
			logger.debug("DisplayFileAction::buildresponse: sitemapParams : "+ sitemapParams);
            logger.debug("nombre d'enum de premier niveau : "+i);
		}catch (Exception e) {
			
			throw new Exception("DisplayFileAction::buildResponse : impossible de retrouver les mtadonnes.\n webdavpath :"+webdavpath, e);
		}
	}
	/**
	 * fetch file-root-name of doc	 
	 * @throws URIException, IOException
	 */	
	private void fetchRootFileName(String docpath)throws URIException, IOException 
	{
		Vector rootv = new Vector();
		rootv.add(mdVector.elementAt(2));
		Enumeration md = getProperty(docpath, rootv);
		if(md.hasMoreElements())
		{	
			org.apache.webdav.lib.BaseProperty prop = (org.apache.webdav.lib.BaseProperty)md.nextElement();
			parseProperty(prop);
			if(rootfilename.equals(""))
				rootfilename=docpath.substring(1);
			logger.debug("DisplayFileAction::fetchRootFileName: root-file-name("+rootdocname+") :"+rootfilename+"\nprop :"+prop);
			
		}
		else
		{	
			logger.debug("DisplayFileAction::fetchRootFileName: no root-file-name for doc :"+rootdocname+"\n--->  taking root-doc-name as file name.");
			rootfilename=docpath.substring(1);
		}	
	}
	private boolean CheckDocPublished(String docname)
	{
		boolean result=true;
		
		boolean published = false;
		boolean checkdate = false;
		String begin="";
		String end="";
		
		try
		{
			logger.debug("CheckDoc : " + rootpath+space+"/"+docname);
			Enumeration md = webdavConnection.getProperties(rootpath+space+"/"+docname, 0);
			while(md.hasMoreElements())
			{
				BaseProperty prop = (BaseProperty)md.nextElement();
				Element el=prop.getElement();
				String tagname =el.getNodeName();
				String value="";
				if(el.hasChildNodes())
					value=el.getFirstChild().getNodeValue();
				String mapname=tagname.substring(tagname.indexOf(":")+1);

//			  publication validity 
				if(mapname.equals("document-state"))
				{
					published= value.equals("published");
					logger.debug("document-state : "+  value);
				}
				if(mapname.equals("publication-date-begin"))
				{
					if(!value.equals(""))
						begin = value;
					logger.debug("publication-date-begin : "+  value);
					
				}
				if(mapname.equals("publication-date-end"))
				{
					if(!value.equals(""))
						end = value;
					logger.debug("publication-date-end : "+  value);
				}
				
			}
			checkdate = DateChecker.checkDate(begin, end);
			result = (published && checkdate);
			
		}
		catch(Exception ex)
		{
			result = false;
		}
		return result;
	
	}
	/**
	 * Connect to the WebDAV server	 
	 * @throws ServerException
	 */
	public void connect(String connexionString) throws Exception
	{
		logger.debug("ConnexionString : "+ connexionString);
		try 
		{
				if((login!=null) && (password!=null))
				{	
					webdavConnection.connect(connexionString, login, password);	
				}
				else
				{
					webdavConnection.connect(connexionString);	
				}
			}
		catch (Exception ex) 
		{	
			logger.error("error connecting to webdav resource : "+ connexionString+"\ncause : "+ex.getCause());	
	        throw ex;
	    }
		logger.debug("Connect : end");			
	}


/**
 * Give the property of resource
 * @return the array of properties
 */
private Enumeration getProperty(Vector properties) throws URIException, IOException 
{
	
	return getProperty("", properties);
 
}

private Enumeration getProperty(String subpath,Vector properties) throws URIException, IOException 
{
	logger.debug("properties :"+ properties);
	logger.debug("PROPFIND webdavpath :"+ webdavpath);
	logger.debug("PROPFIND path :"+ space+subpath);
	logger.debug("PROPFIND rootpath :"+ rootpath);
	logger.debug("PROPFIND propfindpath :"+ rootpath+space+subpath);
	return webdavConnection.getProperties(rootpath+space+subpath, DepthSupport.DEPTH_0, properties);
}

		
}


